/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource;

import de.willuhn.datasource.GenericObject;
import de.willuhn.logging.Logger;
import java.beans.Expression;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BeanUtil {
    public static List<String> getProperties(Object bean) throws RemoteException {
        ArrayList<String> result = new ArrayList<String>();
        if (bean == null) {
            return result;
        }
        if (bean instanceof GenericObject) {
            GenericObject o = (GenericObject)bean;
            result.addAll(Arrays.asList(o.getAttributeNames()));
            return result;
        }
        Method[] methods = bean.getClass().getMethods();
        if (methods == null || methods.length == 0) {
            return result;
        }
        for (Method m : methods) {
            String name = m.getName();
            if (!name.startsWith("get") || name.length() <= 3) continue;
            result.add(BeanUtil.toProperty(name));
        }
        return result;
    }

    public static Object get(Object bean, String attribute) throws RemoteException {
        int dot;
        if (bean == null) {
            return null;
        }
        if (attribute == null) {
            return BeanUtil.toString(bean);
        }
        for (int i = 0; i < 10 && (dot = attribute.indexOf(".")) != -1; ++i) {
            String s = attribute.substring(0, dot);
            if ((bean = BeanUtil.get(bean, s)) == null) {
                return null;
            }
            attribute = attribute.substring(dot + 1);
        }
        if (bean instanceof GenericObject) {
            return ((GenericObject)bean).getAttribute(attribute);
        }
        try {
            return BeanUtil.invoke(bean, BeanUtil.toGetMethod(attribute), null);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (NoSuchMethodException nme) {
            try {
                return BeanUtil.invoke(bean, attribute, null);
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (NoSuchMethodException nme2) {
                Logger.trace((String)nme.getMessage());
                return null;
            }
            catch (Exception e) {
                throw new RemoteException("unable to get attribute " + attribute, e);
            }
        }
        catch (Exception e) {
            throw new RemoteException("unable to get attribute " + attribute, e);
        }
    }

    public static void set(Object bean, String attribute, Object param) throws RemoteException {
        BeanUtil.set(bean, attribute, new Object[]{param});
    }

    public static void set(Object bean, String attribute, Object[] params) throws RemoteException {
        try {
            BeanUtil.invoke(bean, BeanUtil.toSetMethod(attribute), params);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to set attribute " + attribute, e);
        }
    }

    public static String toString(Object bean) throws RemoteException {
        if (bean == null) {
            return null;
        }
        if (bean instanceof GenericObject) {
            GenericObject gb = (GenericObject)bean;
            Object value = gb.getAttribute(gb.getPrimaryAttribute());
            return value == null ? null : value.toString();
        }
        return bean.toString();
    }

    public static boolean equals(Object a, Object b) throws RemoteException {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof GenericObject && b instanceof GenericObject) {
            return ((GenericObject)a).equals((GenericObject)b);
        }
        return a.equals(b);
    }

    public static String toGetMethod(String attribute) {
        return "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
    }

    public static String toSetMethod(String attribute) {
        return "set" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
    }

    public static String toProperty(String method) {
        if (method.length() > 3 && (method.startsWith("get") || method.startsWith("set"))) {
            return method.substring(3, 4).toLowerCase() + method.substring(4);
        }
        return method;
    }

    public static Object invoke(Object bean, String method, Object[] params) throws Exception {
        Expression ex = new Expression(bean, method, params);
        return ex.getValue();
    }

    public static Class getType(Class c) {
        if (c == null) {
            Logger.warn((String)"no (typed) class given");
            return null;
        }
        Class ct = BeanUtil.getActualType(c.getGenericSuperclass());
        if (ct != null) {
            return ct;
        }
        Type[] interfaces = c.getGenericInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return null;
        }
        for (Type t : interfaces) {
            ct = BeanUtil.getActualType(t);
            if (ct == null) continue;
            return ct;
        }
        return null;
    }

    private static Class getActualType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] types = pType.getActualTypeArguments();
        if (types == null || types.length == 0) {
            return null;
        }
        if (!(types[0] instanceof Class)) {
            return null;
        }
        return (Class)types[0];
    }
}

